% Enter the xml files for analysis. The files should be formatted as
% follows {{sample1plate1, sample1plate2},{sample2plate1,sample2plates},
% {sample3plate1, sample3plate2}, ...}
FileCell =  {{'4.26.18 WT#1 P1.xml','4.26.18 WT#1 P2.xml'},...
             {'5.29.18 WT #2 P1.xml','5.29.18 WT #2 P2.xml'},...
             {'5.30.18 WT #3 P1.xml','5.30.18 WT #3 P2.xml'},...
             {'5.31.18 WT #4 P1.xml','5.31.18 WT #4 P2.xml'},...
             };

% Enter the number of wells used in each plate. Format = [plate 1,plate2];
NumWell1 =  [80,88];


% Enter the bioplex bead reigons used. Format = [Region1, Region2, ...].
% Note: make sure the bead region order matches the IP names below. 
Beads1 = [12, 8, 13, 26, 28, 77, 43, 30, 15, 64, 68,...
    85, 45, 89, 91, 47, 70, 96];


% Function that allows for the re-ordering of the Probes (with respect to
% the run order and formatting in the xml output files). 
% Format = [1,2,...],
% Shiftformat1 = plate1, Shiftformat2 = plate2
% Note #1: normally the output will list the probes in numerical order. 
% Note #2: make sure the probe order matches the Probe names below
ShiftFormat1 = [1,2,3,4,5,6,7,8,9,10];
ShiftFormat2 = [11,12,13,14,15,16,17,18,19,20,21];
ShiftFormat = {ShiftFormat1,ShiftFormat2};


% Where are your samples? Wells are numbered starting from A1 to A(max),
% then B1 to B(max), etc.  
% Format = {{plate1rep1,plate2rep1},{plate1rep2,plate2rep2}}
% Note: wells skipped during an aquistion will also be skipped in numbering
% as the numbering is based on the order in the xml output
WC1 = {{[1:10],[1:11]},{[41:50],[45:55]}};
N1 = {{[11:20],[12:22]},{[51:60],[56:66]}};
D1 = {{[21:30],[23:33]},{[61:70],[67:77]}};
A1 = {{[31:40],[34:44]},{[71:80],[78:88]}};
G2 = {{[1:10],[1:11]},{[41:50],[45:55]}};
D2 = {{[11:20],[12:22]},{[51:60],[56:66]}};
N2 = {{[21:30],[23:33]},{[61:70],[67:77]}};
A2 = {{[31:40],[34:44]},{[71:80],[78:88]}};
D3 = {{[1:10],[1:11]},{[41:50],[45:55]}};
A3 = {{[11:20],[12:22]},{[51:60],[56:66]}};
N3 = {{[21:30],[23:33]},{[61:70],[67:77]}};
G3 = {{[31:40],[34:44]},{[71:80],[78:88]}};
G4 = {{[1:10],[1:11]},{[41:50],[45:55]}};
A4 = {{[11:20],[12:22]},{[51:60],[56:66]}};
N4 = {{[21:30],[23:33]},{[61:70],[67:77]}};
D4 = {{[31:40],[34:44]},{[71:80],[78:88]}};

% What are the comparisons? 
% Format {{UNSTIM1 (denominator), STIM1 (numerator)}, {UNSTIM2, STIM2},...}
% Note: the number of entries in the cell must be the same as the number of
% experimental replicates
WellInfoCell = {{A1,N1},{A2,N2},{A3,N3},{A4,N4}};

% This example assumes the formatting is the same for each sample
% This code can be used to modify the analysis if the formatting is
% different between samples.
% Note: the number of entries in the cell must be the same as the number of
% experimental replicates
NumWellCell = {NumWell1,NumWell1,NumWell1,NumWell1};
BeadRegionCell = {Beads1,Beads1,Beads1,Beads1};
ShiftFormatCell = {ShiftFormat,ShiftFormat,ShiftFormat,ShiftFormat};

% IP and Probe Names
% Note: the IP and Probe names need to match with the analysis order listed
% above
IP_Names = {'Fyn','PSD95','NMDAR1','NMDAR2A','NMDAR2B','mGluR5',...
    'Shank3','Homer1', 'PI3K','GluR1','GluR2','SynGAP','SAP97','NL3',...
    'Ube3A', 'CamKII', 'PIKE','Shank1'};
Probe_Names = {'Fyn','PSD95','NMDAR1','NMDAR2A','NMDAR2B','mGlur5',...
    'Shank3','Homer1','Homer1a','PI3K','GluR1','GluR2','SynGAP',...
    'SAP97','NL3','Ube3a','CamKII', 'SAPAP', 'panShank', 'Shank1','PIKE'};

% Name the experiments and conditions.
% Note: do not include spaces, as this will cause errors in the output 
% files and underlying code
ExpId = {'Exp1','Exp2','Exp3','Exp4'};
CondId = {'ACSF','NMDA'};
CellType = 'WT_aCSF_v_NMDA';

% Calling of the master function to run the analysis. This will also call
% on subfunctions to work.
MultiplexFullAnalysis_2or3Plates_wXML(FileCell,WellInfoCell,...
    ShiftFormatCell,NumWellCell,BeadRegionCell,IP_Names,...
    Probe_Names,ExpId,CondId,CellType);

